/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.worldtracker.CapabilityWorldTracker;
import net.dries007.tfc.api.capability.worldtracker.CollapseData;
import net.dries007.tfc.api.capability.worldtracker.WorldTracker;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.objects.entity.EntityFallingBlockTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FallingBlockManager {
    private static final Set<Material> SOFT_MATERIALS = new ObjectOpenHashSet((Object[])new Material[]{Material.field_151578_c, Material.field_151595_p, Material.field_151577_b, Material.field_151571_B});
    private static final Set<Material> HARD_MATERIALS = new ObjectOpenHashSet((Object[])new Material[]{Material.field_151573_f, BlockCharcoalPile.CHARCOAL_MATERIAL});
    private static final Map<IBlockState, Specification> FALLABLES = new Object2ObjectOpenHashMap();
    private static final Set<IBlockState> SIDE_SUPPORTS = new ObjectOpenHashSet(0);

    public static void registerSoftMaterial(Material material) {
        SOFT_MATERIALS.add(material);
    }

    public static void registerHardMaterial(Material material) {
        HARD_MATERIALS.add(material);
    }

    public static void registerFallable(IBlockState state, Specification specification) {
        FALLABLES.put(state, specification);
    }

    public static void registerFallable(Block block, Specification specification) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            FALLABLES.put(state, specification);
        }
    }

    public static void registerSideSupports(IBlockState state) {
        SIDE_SUPPORTS.add(state);
    }

    public static void registerSideSupports(Block block) {
        SIDE_SUPPORTS.addAll((Collection<IBlockState>)block.func_176194_O().func_177619_a());
    }

    public static void removeSoftMaterial(Material material) {
        SOFT_MATERIALS.remove(material);
    }

    public static void removeHardMaterial(Material material) {
        HARD_MATERIALS.remove(material);
    }

    public static void removeFallable(IBlockState state) {
        FALLABLES.remove(state);
    }

    public static void removeFallable(Block block) {
        block.func_176194_O().func_177619_a().forEach(FALLABLES::remove);
    }

    public static void removeSideSupport(IBlockState state) {
        SIDE_SUPPORTS.remove(state);
    }

    public static void removeSideSupport(Block block) {
        block.func_176194_O().func_177619_a().forEach(SIDE_SUPPORTS::remove);
    }

    @Nullable
    public static Specification getSpecification(IBlockState state) {
        return FALLABLES.get(state);
    }

    public static boolean canFallThrough(World world, BlockPos pos, Material fallingBlockMaterial) {
        return FallingBlockManager.canFallThrough(world, pos, fallingBlockMaterial, world.func_180495_p(pos));
    }

    public static boolean canFallThrough(World world, BlockPos pos, Material fallableMaterial, IBlockState targetState) {
        if (BlockFalling.func_185759_i((IBlockState)targetState)) {
            return true;
        }
        if (SOFT_MATERIALS.contains(fallableMaterial) && HARD_MATERIALS.contains(targetState.func_185904_a()) || targetState.func_185887_b(world, pos) == -1.0f) {
            return false;
        }
        if (!world.isSideSolid(pos, EnumFacing.UP)) {
            return true;
        }
        return !targetState.func_185913_b();
    }

    public static boolean hasSupportingSideBlock(IBlockState state) {
        return state.func_185915_l() || SIDE_SUPPORTS.contains(state) || state.func_177230_c() instanceof BlockRockVariant && (((BlockRockVariant)state.func_177230_c()).getType() == Rock.Type.FARMLAND || ((BlockRockVariant)state.func_177230_c()).getType() == Rock.Type.PATH);
    }

    public static boolean shouldFall(World world, BlockPos posToFallFrom, BlockPos originalPos, IBlockState originalState, boolean ignoreSupportChecks) {
        return ConfigTFC.General.FALLABLE.enable && FallingBlockManager.canFallThrough(world, posToFallFrom.func_177977_b(), originalState.func_185904_a()) && (ignoreSupportChecks || !BlockSupport.isBeingSupported(world, originalPos));
    }

    public static boolean canCollapse(World world, BlockPos pos) {
        return FallingBlockManager.canCollapseAt(world, pos.func_177977_b());
    }

    public static boolean canCollapseAt(World world, BlockPos pos) {
        return FallingBlockManager.canCollapseAt(world.func_180495_p(pos));
    }

    public static boolean canCollapseAt(IBlockState state) {
        return state.func_185904_a().func_76222_j();
    }

    @Nullable
    public static BlockPos getFallablePos(World world, BlockPos pos, IBlockState state, boolean ignoreSupportChecks) {
        Specification specification = FALLABLES.get(state);
        if (specification == null) {
            return null;
        }
        if (FallingBlockManager.shouldFall(world, pos, pos, state, ignoreSupportChecks)) {
            return FallingBlockManager.checkAreaClear(world, state, pos);
        }
        if (specification.canFallHorizontally) {
            if (FallingBlockManager.hasSupportingSideBlock(world.func_180495_p(pos.func_177984_a()))) {
                return null;
            }
            ObjectArrayList candidates = new ObjectArrayList(4);
            boolean hasFoundSideSupport = false;
            for (EnumFacing horizontalFace : EnumFacing.field_176754_o) {
                BlockPos offsetPos = pos.func_177972_a(horizontalFace);
                IBlockState offsetState = world.func_180495_p(offsetPos);
                if (FallingBlockManager.hasSupportingSideBlock(offsetState)) {
                    if (hasFoundSideSupport) {
                        return null;
                    }
                    hasFoundSideSupport = true;
                }
                if (!FallingBlockManager.shouldFall(world, offsetPos, pos, state, ignoreSupportChecks) || !FallingBlockManager.canFallThrough(world, offsetPos, state.func_185904_a(), offsetState)) continue;
                candidates.add(offsetPos);
            }
            return candidates.isEmpty() ? null : FallingBlockManager.checkAreaClear(world, state, (BlockPos)candidates.get(Constants.RNG.nextInt(candidates.size())));
        }
        return null;
    }

    public static boolean checkFalling(World world, BlockPos pos, IBlockState state) {
        return FallingBlockManager.checkFalling(world, pos, state, false);
    }

    public static boolean checkFalling(World world, BlockPos pos, IBlockState state, boolean ignoreSupportChecks) {
        BlockPos fallablePos;
        if (BlockFalling.field_149832_M) {
            if (!world.func_175707_a(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(2, 2, 2))) {
                return false;
            }
            BlockPos fallablePos2 = FallingBlockManager.getFallablePos(world, pos, state, ignoreSupportChecks);
            if (fallablePos2 == null) {
                return false;
            }
            world.func_175698_g(pos);
            BlockPos.MutableBlockPos fallingPos = new BlockPos.MutableBlockPos(fallablePos2);
            fallingPos.func_185336_p(fallingPos.func_177956_o() - 1);
            while (FallingBlockManager.canFallThrough(world, (BlockPos)fallingPos, state.func_185904_a()) && fallingPos.func_177956_o() > 0) {
                fallingPos.func_185336_p(fallingPos.func_177956_o() - 1);
            }
            if (fallablePos2.func_177956_o() > 0) {
                fallingPos.func_185336_p(fallingPos.func_177956_o() + 1);
                world.func_175656_a(fallingPos.func_185334_h(), state);
            }
            return false;
        }
        if (world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32)) && (fallablePos = FallingBlockManager.getFallablePos(world, pos, state, ignoreSupportChecks)) != null) {
            if (!fallablePos.equals((Object)pos)) {
                world.func_82736_K().func_82764_b("doTileDrops", Boolean.toString(false));
                world.func_175698_g(pos);
                world.func_175656_a(fallablePos, state);
                world.func_82736_K().func_82764_b("doTileDrops", Boolean.toString(true));
            }
            world.func_72838_d((Entity)new EntityFallingBlockTFC(world, fallablePos, state));
            return true;
        }
        return false;
    }

    public static boolean checkCollapsingArea(World world, BlockPos pos) {
        if (world.field_72995_K || !world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
            return false;
        }
        if (Constants.RNG.nextDouble() < ConfigTFC.General.FALLABLE.collapseChance) {
            int radX = (Constants.RNG.nextInt(5) + 4) / 2;
            int radY = (Constants.RNG.nextInt(3) + 2) / 2;
            int radZ = (Constants.RNG.nextInt(5) + 4) / 2;
            for (BlockPos checking : BlockSupport.getAllUnsupportedBlocksIn(world, pos.func_177982_a(-radX, -radY, -radZ), pos.func_177982_a(radX, radY, radZ))) {
                IBlockState state = world.func_180495_p(checking);
                Specification spec = FallingBlockManager.getSpecification(state);
                if (spec == null || !spec.collapsable || !spec.collapseChecker.canCollapse(world, checking)) continue;
                FallingBlockManager.collapseArea(world, checking);
                world.func_184133_a(null, pos, TFCSounds.ROCK_SLIDE_LONG, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static void collapseArea(World world, BlockPos centerPoint) {
        WorldTracker tracker;
        int radius = (world.field_73012_v.nextInt(31) + 5) / 2;
        int radiusSquared = radius * radius;
        ArrayList<BlockPos> secondaryPositions = new ArrayList<BlockPos>();
        block0: for (BlockPos pos : BlockPos.func_177975_b((BlockPos)centerPoint.func_177982_a(-radius, -4, -radius), (BlockPos)centerPoint.func_177982_a(radius, -4, radius))) {
            boolean foundEmpty = false;
            for (int y = 0; y <= 8; ++y) {
                Specification specAt;
                BlockPos posAt = pos.func_177981_b(y);
                IBlockState stateAt = world.func_180495_p(posAt);
                if (foundEmpty && (specAt = FallingBlockManager.getSpecification(stateAt)) != null && specAt.collapsable && specAt.collapseChecker.canCollapse(world, posAt) && !BlockSupport.isBeingSupported(world, posAt) && posAt.func_177951_i((Vec3i)centerPoint) < (double)radiusSquared && (double)world.field_73012_v.nextFloat() < ConfigTFC.General.FALLABLE.propagateCollapseChance) {
                    IBlockState resultState = specAt.getResultingState(stateAt);
                    world.func_175656_a(posAt, resultState);
                    FallingBlockManager.checkFalling(world, posAt, resultState, true);
                    secondaryPositions.add(posAt.func_177984_a());
                    continue block0;
                }
                if (!FallingBlockManager.canFallThrough(world, posAt, stateAt.func_185904_a(), stateAt)) continue;
                foundEmpty = true;
            }
        }
        if (!secondaryPositions.isEmpty() && (tracker = (WorldTracker)world.getCapability(CapabilityWorldTracker.CAPABILITY, null)) != null) {
            tracker.addCollapseData(new CollapseData(centerPoint, secondaryPositions, radiusSquared));
        }
    }

    @Nullable
    public static BlockPos checkAreaClear(World world, IBlockState state, BlockPos pos) {
        if (!world.func_72872_a(EntityFallingBlock.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1))).isEmpty()) {
            world.func_175684_a(pos, state.func_177230_c(), 20);
            return null;
        }
        return pos;
    }

    private FallingBlockManager() {
    }

    public static class Specification {
        public static final IFallDropsProvider DEFAULT_DROPS_PROVIDER = (world, pos, state, teData, fallTime, fallDistance) -> Collections.singletonList(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state)));
        public static final ICollapseChecker DEFAULT_COLLAPSE_CHECKER = (world, collapsePos) -> world.func_180495_p(collapsePos.func_177977_b()).func_185904_a().func_76222_j();
        public static final Specification VERTICAL_AND_HORIZONTAL = new Specification(true, () -> TFCSounds.DIRT_SLIDE_SHORT);
        public static final Specification VERTICAL_ONLY = new Specification(false, () -> TFCSounds.DIRT_SLIDE_SHORT);
        public static final Specification COLLAPSABLE = new Specification(false, true, () -> TFCSounds.ROCK_SLIDE_LONG);
        private final boolean canFallHorizontally;
        private final Supplier<SoundEvent> soundEventDelegate;
        private final IFallDropsProvider fallDropsProvider;
        private final boolean collapsable;
        private ICollapseChecker collapseChecker;
        @Nullable
        private IBlockState resultingState;
        @Nullable
        private IBeginFallCallback beginFallCallback;
        @Nullable
        private IEndFallCallback endFallCallback;

        public Specification(Specification specification) {
            this.canFallHorizontally = specification.canFallHorizontally;
            this.collapsable = specification.collapsable;
            this.collapseChecker = specification.collapseChecker;
            this.soundEventDelegate = specification.soundEventDelegate;
            this.fallDropsProvider = specification.fallDropsProvider;
            this.resultingState = specification.resultingState;
            this.beginFallCallback = specification.beginFallCallback;
            this.endFallCallback = specification.endFallCallback;
        }

        public Specification(boolean canFallHorizontally, Supplier<SoundEvent> soundEventDelegate) {
            this(canFallHorizontally, false, soundEventDelegate, DEFAULT_DROPS_PROVIDER);
        }

        public Specification(boolean canFallHorizontally, boolean collapsable, Supplier<SoundEvent> soundEventDelegate) {
            this(canFallHorizontally, collapsable, soundEventDelegate, DEFAULT_DROPS_PROVIDER);
        }

        public Specification(boolean canFallHorizontally, boolean collapsable, Supplier<SoundEvent> soundEventDelegate, IFallDropsProvider fallDropsProvider) {
            this.canFallHorizontally = canFallHorizontally;
            this.collapsable = collapsable;
            if (this.collapsable) {
                this.collapseChecker = DEFAULT_COLLAPSE_CHECKER;
            }
            this.soundEventDelegate = soundEventDelegate;
            this.fallDropsProvider = fallDropsProvider;
        }

        public void setResultingState(IBlockState state) {
            this.resultingState = state;
        }

        public void setBeginFallCallback(IBeginFallCallback callback) {
            this.beginFallCallback = callback;
        }

        public void setEndFallCallback(IEndFallCallback callback) {
            this.endFallCallback = callback;
        }

        public void setCollapseCondition(ICollapseChecker collapseChecker) {
            this.collapseChecker = collapseChecker;
        }

        public boolean canFallHorizontally() {
            return this.canFallHorizontally;
        }

        public boolean isCollapsable() {
            return this.collapsable;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEventDelegate.get();
        }

        @Nullable
        public IBlockState getResultingState() {
            return this.resultingState;
        }

        @Nonnull
        public IBlockState getResultingState(IBlockState originalState) {
            return this.resultingState == null ? originalState : this.resultingState;
        }

        public Iterable<ItemStack> getDrops(World world, BlockPos pos, IBlockState state, @Nullable NBTTagCompound teData, int fallTime, float fallDistance) {
            return this.fallDropsProvider.getDropsFromFall(world, pos, state, teData, fallTime, fallDistance);
        }

        public boolean canCollapse(World world, BlockPos pos) {
            return this.collapseChecker.canCollapse(world, pos);
        }

        public void beginFall(World world, BlockPos pos) {
            if (this.beginFallCallback != null) {
                this.beginFallCallback.beginFall(world, pos);
            }
        }

        public void endFall(World world, BlockPos pos) {
            if (this.endFallCallback != null) {
                this.endFallCallback.endFall(world, pos);
            }
        }

        @FunctionalInterface
        public static interface ICollapseChecker {
            public boolean canCollapse(World var1, BlockPos var2);
        }

        @FunctionalInterface
        public static interface IEndFallCallback {
            public void endFall(World var1, BlockPos var2);
        }

        @FunctionalInterface
        public static interface IBeginFallCallback {
            public void beginFall(World var1, BlockPos var2);
        }

        @FunctionalInterface
        public static interface IFallDropsProvider {
            public Iterable<ItemStack> getDropsFromFall(World var1, BlockPos var2, IBlockState var3, @Nullable NBTTagCompound var4, int var5, float var6);
        }
    }
}

